package IMPL::DOM::Navigator::Builder;
use strict;
use warnings;

use base qw(IMPL::DOM::Navigator);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
require IMPL::DOM::Navigator::SchemaNavigator;

BEGIN {
    protected _direct property _schemaNavi => prop_all;
    public _direct property Document => prop_get | owner_set;
}

our %CTOR = (
    'IMPL::DOM::Navigator' => sub { $_[0] } # IMPL::DOM::Navigator($domDocument)
);

sub CTOR {
    my ($this,$domDocument,$schema) = @_;
    
    $this->{$Document} = $domDocument;
    $this->{$_schemaNavi} = $schema;
}

sub NavigateCreate {
    my ($this,$nodeName,%props) = @_;
    
    
}

sub Back {
    my ($this) = @_;
    
}

1;

__END__
=pod

=head1 SYNOPSIS

my $builder = new IMPL::DOM::Navigator::Builder(new MyApp::Document,$schema);
my $reader = new IMPL::DOM::XMLReader(Navigator => $builder);

$reader->ParseFile("document.xml");

my @errors = $schema->Validate($builder->Document);

=head1 DESCRIPTION

 DOM    .    
      C<IMPL::DOM::XMLReader>.

=head1 METHODS

=over

=item C<CTOR($domDocument,$schema)>

  ,     (  )  
.

=item C<< $obj->NavigateCreate($nodeName) >>

         .     
   ,   .

      ,     
 ,  

=over

=item   C<type>    ,   

=item   C<type>   ,   , 
 .

=item      

=back

        C<nodeName>.

..   C<< <ComplexNode nodeName="Box" type="Container"> >> 
  C<< Container->new(nodeName => 'Box') >>.

=back

=cut