#!/usr/bin/perl
use strict;

use Time::HiRes qw(gettimeofday tv_interval);

my $obj = {};
my @vals = qw(a b c d e f g h i j k);
my @names = qw(one two three four five six);

sub CreateMethod {
    my ($dt) = @_;
    
    $obj->{one} = $vals[1];
    $obj->{two} = $vals[2];
    $obj->{three} = $vals[3];
    $obj->{four} = $vals[4];
    $obj->{five} = $vals[5];
    $obj->{six} = $vals[6];
}

my @pairs = map { [$names[$_],$_] } (1 .. $#names);

sub CreateMethodEval {
	my ($dt) = @_;
    my $i = 0;
    map $obj->{$_} = $vals[$i++], @names;
}
    
my $t = [gettimeofday];



CreateMethod($_) foreach (1..1000000);

print "Build: ",tv_interval($t,[gettimeofday]),"\n";

$t = [gettimeofday];

CreateMethodEval($_) foreach (1..1000000);

print "Eval: ",tv_interval($t,[gettimeofday]),"\n";

use URI::Escape;

print uri_escape("/child///&?"), "\n";

