package IMPL::Security::Auth;

use Digest::MD5 qw(md5_hex);

use constant {
	AUTH_SUCCESS => 1,
	AUTH_INCOMPLETE => 2,
	AUTH_FAIL => 3	
};

use parent qw(Exporter);

our @EXPORT_OK = qw(&AUTH_SUCCESS &AUTH_INCOMPLETE &AUTH_FAIL &GenSSID);
our %EXPORT_TAGS = (Const => [qw(&AUTH_SUCCESS &AUTH_INCOMPLETE &AUTH_FAIL)]);

{
    my $i = 0;
    sub GenSSID() {
        return md5_hex(time,rand,$i++);
    }
}

sub DoAuth {
	die new IMPL::NotImplementedException;
}

sub ValidateSession {
	die new IMPL::NotImplementedException;
}

sub isTrusted {
	0;
}

sub Create {
	my ($self,%args) = @_;
	
	return $self->new($self->CreateSecData(%args));
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Auth>     .

=head1 DESCRIPTION

C<[Abstract]>

   ,      
   .

   ,      
.

         C<$challenge>.
       (C<AUTH_SUCCESS>),    
(C<AUTH_INCOMPLETE>),   (C<AUTH_FAIL>).     ,
   .

=head1 EXPORT

=over

=item C<:Const>

  

=over

=item C<AUTH_SUCCESS>

 

=item C<AUTH_INCOMPLETE>

  

=item C<AUTH_FAIL>

 .

=back

=back

=head1 MEMBERS

=over

=item C<CTOR($SecData)>

         .
C<$SecData> -    .

=item C<[get] isTrusted>

 ,    .

=item C<DoAuth($challenge)>

     ,
  ,    ($status,$challenge).

      C<$challenge>
  .

=item C<ValidateSession($challenge)>

  ,   ,
   ($status,$challenge).

=item C<[static] CreateSecData(%args)>

  ,   .     .

=item C<[static] Create(%args)>

  ,   .     .
   C<CreateSecData(%args)>.

=item C<[static] SecDataArgs()>

       C<CreateSecData>.  
 ,  - .

=back 

=cut