package IMPL::Web::QueryHandler;

use parent qw(IMPL::Object IMPL::Object::Autofill IMPL::Object::Serializable);
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

use IMPL::Exception;

sub Invoke {
	my ($self,$action,$nextHandler) = @_;
	
	if (not ref $self) {
		return $self->new( action => $action )->Invoke($action,$nextHandler);
	} else {
		return $self->Process($action,$nextHandler);
	}
}

sub Process {
	die new IMPL::NotImplementedException("The method isn't implemented", __PACKAGE__, 'Process');
}

1;

__END__

=pod

=head1 NAME

    .

=head1 SYNOPSIS

 

=begin code

package MyHandler;

use parent qw(IMPL::Web::QueryHandler);

sub CTOR {
	my ($this,%args) = @_;
	
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
}

=end code

=head1 MEMBERS

=over 4

=item C< Invoke($action,$nextHandler) >

   ,    .  
  ,    ,      
    C< Invoke >   C< $action >, C< $nextHandler >.

         C<action>. 

     ,     C< Process >.

=over

=item C< $action >

 

=item C< $nextHandler >

    .   ,   
    .

=back

=back

=cut