package IMPL::clone;

use Scalar::Util qw(blessed reftype refaddr);

use base qw(Exporter);
our @EXPORT_OK = qw(&clone);

{
	my %handlers = (
		HASH => sub {
			my $class = blessed($_[0]);
			
			my $new = {};
			while (my ($key,$val) = each %{$_[0]}) {
				$new->{$key} = clone($val,$_[1]);
			}
			$class ? bless $new, $class : $new;
		},
		ARRAY => sub {
			my $class = blessed($_[0]);
			$class ? bless( [ map clone($_,$_[1]), @{$_[0]} ], $class ) : [ map clone($_), @{$_[0]} ];
		},
		SCALAR => sub {
			my $class = blessed($_[0]);
			
			my $v = ${$_[0]};
			$class ? bless \$v, $class : \$v;
		},
		REF => sub {
			my $class = blessed($_[0]);
			my $v = clone ( ${$_[0]},$_[1] );
			$class ? bless \$v, $class : \$v;
			
		},
		REGEXP => sub {
			$_[0];
		}
	);
	
	sub clone {
		return unless @_;
		
		return $_[0] unless ref $_[0];
		
		return $_[1]->{refaddr($_[0])} ||= ($handlers{reftype($_[0])} || sub { die "Unknown reftype " . reftype($_[0])} )->($_[0]);
	}
	
}

1;
