package IMPL::SQL::Schema::Traits::MysqlFormatter;
use strict;

sub quote{
	my $self = shift;
	
    if (wantarray) {
        return map { my $str=$_; $str=~ s/'/''/g; "'$str'"; } @_;
    } else {
        return join '',map { my $str=$_; $str=~ s/'/''/g; "'$str'"; } @_;
    }
}

sub quote_names {
	my $self = shift;
	
    if (wantarray) {
        return map { my $str=$_; $str=~ s/`/``/g; "`$str`"; } @_;
    } else {
        return join '',map { my $str=$_; $str=~ s/`/``/g; "`$str`"; } @_;
    }
}

sub FormatTypeName {
	my ($self,$type) = @_;
	
}

sub FormatValue {
	my ($self,$value,$type) = @_;
}

sub FormatColumn {
	my ($self, $column) = @_;
	
	my @parts = (
	   $self->quote_names($column->{name}),
	   $self->FormatTypeName($column->{type}),
	   $column->isNullable ? 'NULL' : 'NOT NULL'
    );
    
    push @parts, $self->FormatValue( $column->{defaultValue}, $column->{type} )
        if $column->{defaultValue};
        
    push @parts, 'AUTO_INCREMENT'
        if $column->{tag} and $column->{tag}->{auto_increment};
	
	return join ' ', @parts;
}

sub FormatCreateTable {
	my ($self,$op) = @_;
	
	my $table = $op->table;
	
	my @lines;
	
	push @lines, "CREATE TABLE (";
	
	push @lines, map { "  " . $self->FormatColumn($_) } @{$table->{columns}}
	   if $table->{columns};
	
	push @lines, ");";
	
	return join "\n",@lines;
}

sub FormatDropTable {
	my ($self,$op) = @_;
	
	return join ' ',
	   'DROP TABLE',
	   $self->quote_names($op->{tableName}),
	   ';';
}

sub FormatRenameTable {
	my ($self,$op) = @_;
	
	return join ' ',
	   'ALTER TABLE',
	   $self->quote_names($op->{tableName}),
	   'RENAME TO',
	   $self->quote_names($op->{tableNewName}),
	   ';';	
}

sub FormatAlterTableAddColumn {
	my ($this,$op,$schema) = @_;
	
	my @parts;
	
	$schema->GetTable($op->{tableName})
}

1;