package IMPL::Resources::Format;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(&FormatMessage);

sub FormatMessage {
    my ($string,$args) = @_;
    
    $string =~ s/%(\w+(?:\.\w+)*)%/_getvalue($args,$1,"\[$1\]")/ge;
    
    return $string;
}

sub _getvalue {
    my ($obj,$path,$default) = @_;
    
    foreach my $chunk (split /\./,$path) {
        if (eval { $obj->can( $chunk ) } ) {
            $obj = $obj->$chunk();
        } elsif (UNIVERSAL::isa($obj,'HASH')) {
            $obj = $obj->{$chunk};
        } else {
            return $default;
        }
    }
    return $obj;
}

1;
