package IMPL::SQL::Schema::Constraint;
use strict;
use warnings;

use IMPL::lang;
use IMPL::Const qw(:prop);
use IMPL::declare {
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Disposable' => undef
    ],
    props => [
        name => PROP_RO | PROP_DIRECT,
        table => PROP_RO | PROP_DIRECT,
        columns => PROP_RO | PROP_LIST
    ]
};

my %aliases;

sub CTOR {
    my ($this,%args) = @_;
    is( $args{table}, 'IMPL::SQL::Schema::Table' ) or
        die new IMPL::InvalidArgumentException("table argument must be a table object");
    $this->{$name} = $args{'name'};
    $this->{$table} = $args{'table'};
    $this->columns( [map { ResolveColumn($this->table,$_) } @{$args{'columns'}}] );
}

sub ResolveColumn {
    my ($Table,$Column) = @_;
    
    my $cn = is($Column,'IMPL::SQL::Schema::Column') ? $Column->name : $Column;
    
    my $resolved = $Table->GetColumn($cn);
    die new IMPL::InvalidOperationException("The column is not found in the table", $cn, $Table->name) if not $resolved;
    return $resolved;
}

sub HasColumn {
    my ($this,@Columns) = @_;
    
    my %Columns = map { $_, 1} @Columns;
    
    return scalar(grep { $Columns{$_->name} } $this->columns ) == scalar(@Columns);
}

sub uniqName {
    my ($this) = @_;
    return $this->{$table}->name.'_'.$this->{$name};
}

sub Dispose {
    my ($this) = @_;
    
    $this->columns([]);
    
    delete $$this{$table};
    
    $this->SUPER::Dispose;
}

sub SameValue {
    my ($this,$other) = @_;
            
    return 0 unless $this->columns->Count == $other->columns->Count;
    
    for ( my $i=0; $i < $this->columns->Count; $i++ ) {
        return 0 unless $this->columns->[$i]->name eq $other->columns->[$i]->name;
    }
    
    return 1;
}

sub ResolveAlias {
    my ($self,$alias) = @_;
    
    return isclass($alias, 'IMPL::SQL::Schema::Constraint') ? $alias : $aliases{$alias};
}

sub RegisterAlias {
    my ($self,$alias) = @_;
    
    $aliases{$alias} = ref $self ? typeof($self) : $self;
}

1;
