#!/usr/bin/perl
use strict;
use Carp;
use Time::HiRes qw(gettimeofday tv_interval);
use Scalar::Util qw(blessed refaddr);
use YAML::XS qw(Dump Load);



use IMPL::require {
	Container => 'IMPL::Config::Container',
	Service => 'IMPL::Config::ServiceDescriptor',
	Reference => 'IMPL::Config::ReferenceDescriptor',
	Value => 'IMPL::Config::ValueDescriptor'
};

my $data;
{
	open my $h, "<", "sample.yaml" or die;
	print "H: ", *{$h}{IO}, "\n";
	binmode $h;
	local $/;
	$data = <$h>;
}

my $t = [gettimeofday];

print Dump Load($data);

print "Activated: ",tv_interval($t,[gettimeofday]),"\n";


1;
