package IMPL::Config::ValueDescriptor;
use strict;

use IMPL::lang qw(:base);
use IMPL::declare {
	require => {
		Descriptor => 'IMPL::Config::Descriptor'
	},
	base => [
		'IMPL::Object' => undef,
		'Descriptor'   => undef
	],
	props => [
		value => 'rw',
		raw   => 'rw'
	]
};

sub CTOR {
	my ( $this, $value, $raw ) = @_;

	$this->value($value);
	$this->raw($raw);
}

sub Activate {
	my ( $this, $context ) = @_;

	return $this->raw
	  ? $this->value
	  : $this->_ActivateValue( $this->value, $context );
}

sub _ActivateValue {
	my ( $this, $value, $context ) = @_;

	if ( is( $value, Descriptor ) ) {
		return $value->Activate($context);
	}
	elsif ( isarray($value) ) {
		return [ map $this->_ActivateValue($_, $context), @$value ];
	}
	elsif ( ishash($value) ) {
		return {
			map { $_, $this->_ActivateValue( $value->{$_}, $context ) }
			  keys %$value
		};
	}
	else {
		return $value;
	}
}

1;
