package IMPL::Object;
use strict;

use parent qw(IMPL::Object::Abstract);
use IMPL::require {
    ClassPropertyImplementor => 'IMPL::Code::DirectPropertyImplementor'
};

sub surrogate {
    bless {}, ref $_[0] || $_[0];
}

sub new {
    my $class = shift;
    my $self = bless {}, ref($class) || $class;    
    $self->callCTOR(@_);
  
    $self;
}

1;

__END__

=pod

=head1 SINOPSYS

=begin code

package Foo;
use parent qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Foo: $arg\n";
}

package Bar;
use parent qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Bar: $arg\n";
}

package Baz;
use parent qw(Foo Bar);

our %CTOR = (
    Foo => sub { my %args = @_; $args{Mazzi}; },
    Bar => sub { my %args = @_; $args{Fugi}; }
);

package Composite;
use parent qw(Baz Foo Bar);

our %CTOR = (
    Foo => undef,
    Bar => undef
);

sub CTOR {
    my ($this,%args) = @_;
    
    print "Composite: $args{Text}\n";
}

package main;

my $obj = new Composite(
    Text => 'Hello World!',
    Mazzi => 'Mazzi',
    Fugi => 'Fugi'
);

# will print
#
# Foo: Mazzi
# Bar: Fugi
# Bar:
# Composite: Hello World!

=end code

=head1 Description

Базовый класс для объектов, основанных на хеше.

=head1 Members

=over

=item operator C<new>(@args)

Создает экземпляр объекта и вызывает конструктор с параметрами @args.

=item operator C<surrogate>()

Создает неинициализированный экземпляр объекта.

=back

=head1 Cavearts

Нужно заметить, что директива C<use parent> работает не совсем прозрачно, если в нашем примере
класс C<Composite> наследуется от C<Baz>, а затем C<Foo>, то наследование от
C<Foo> не произойдет поскольку он уже имеется в C<Baz>. Вот не задача:)

=cut
