package IMPL::DOM::Schema::ValidationError;
use strict;
use warnings;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::Resources::Format qw(FormatMessage);

BEGIN {
    public _direct property Node => prop_get;
    public _direct property Schema => prop_get;
    public _direct property Source => prop_get;
    public _direct property Message => prop_get;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Node} = $args{Node};
    $this->{$Schema} = $args{Schema} if $args{Schema};
    $this->{$Source} = $args{Source} if $args{Source};
    $this->{$Message} = FormatMessage(delete $args{Message}, \%args) if $args{Message};
}

1;
