package Engine::Security::IPSession;
use strict;
use Digest::MD5 qw(md5_hex);

our %IPMap; # { IP_ADDR => {user => 'name', ClientSecData => 'ClientData', InitSecData => 'ServerData'} }

sub ReadSecData {
    
    return $IPMap{$ENV{REMOTE_ADDR} || ''} ? $IPMap{$ENV{REMOTE_ADDR} || ''}->{ClientSecData} : undef; # avoid from create hash item
}

sub WriteSecData {
    my ($class,$data) = @_;
    # does nothing
}

sub ReadSSID {
    my ($class,$authEngineObj) = @_;
    
    my $ip = $ENV{REMOTE_ADDR};
    return undef if not $IPMap{$ip || ''};
    my $SSID = md5_hex($ip);
    
    if (not my $session = $authEngineObj->AuthMod->DS->LoadSession($SSID)) {
        my $User = $authEngineObj->AuthMod->DS->FindUser($IPMap{$ip}->{user}) or warn "can't authenticate the $ip: user not found" and return undef;
        $authEngineObj->AuthMod->DS->CreateSession($SSID,$User,$authEngineObj->AuthMod->SecPackage->NewAuthData($IPMap{$ip}->{InitSecData}));
    } elsif ($session->User->Name ne $IPMap{$ip}->{user}) {
        # update user
        my $User = $authEngineObj->AuthMod->DS->FindUser($IPMap{$ip}->{user});
        if ($User) {
            $session->User($User);
        } else {
            warn "can't authenticate the $ip: user not found";
            $authEngineObj->AuthMod->DS->CloseSession($session);
        }
    }
    
    return $SSID;
}

sub WriteSSID {
    my ($class,$data) = @_;
    
    #do nothing
}


1;
