package IMPL::DOM::Schema::NodeSet;
use strict;
use warnings;

use base qw(IMPL::DOM::Node);
use IMPL::Class::Property;

our %CTOR = (
    'IMPL::DOM::Node' => sub { nodeName => 'NodeSet' }
);

BEGIN {
    public property messageUnexpected => prop_all;
    public property messageMax => prop_all;
    public property messageMin => prop_all;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageMax( $args{messageMax} || 'Too many %Node.nodeName% nodes');
    $this->messageMin( $args{messageMin} || '%Schema.name% nodes expected');
    $this->messageUnexpected( $args{messageUnexpected} || 'A %Node.nodeName% isn\'t allowed in %Node.parentNode.path%');
}

sub Validate {
    my ($this,$node) = @_;
    
    my @errors;
    
    my %nodes;
    my $anyNode;
    foreach (@{$this->childNodes}) {
        if ($_->isa('IMPL::DOM::Schema::AnyNode')) {
            $anyNode = {Schema => $_, Min => $_->minOccur, Max => $_->maxOccur eq 'unbounded' ? undef : $_->maxOccur , Seen => 0 };
        } else {
            $nodes{$_->name} = {Schema => $_, Min => $_->minOccur, Max => $_->maxOccur eq 'unbounded' ? undef : $_->maxOccur , Seen => 0 };
        }
    }
    
    foreach my $child ( @{$node->childNodes} ) {
        if (my $info = $nodes{$child->nodeName} || $anyNode) {
            $info->{Seen}++;
            push @errors,new IMPL::DOM::Schema::ValidationError (
                Source => $this,
                Node => $child,
                Schema => $info->{Schema},
                Message => $this->messageMax
            ) if ($info->{Max} and $info->{Seen} > $info->{Max});
            
            if (my @localErrors = $info->{Schema}->Validate($child)) {
                push @errors,@localErrors;
            }
        } else {
            push @errors, new IMPL::DOM::Schema::ValidationError (
                Source => $this,
                Node => $child,
                Message => $this->messageUnexpected
            )
        }
    }
    
    foreach my $info (values %nodes) {
        push @errors, new IMPL::DOM::Schema::ValidationError (
            Source => $this,
            Schema => $info->{Schema},
            Message => $this->messageMin
        ) if $info->{Min} > $info->{Seen};
    }
    
    return @errors;
}

1;

__END__

=pod

=head1 DESCRIPTION

   .   .    
 C<IMPL::DOM::Schema::ComplexNode>  C<IMPL::DOM::Schema::SimpleNode>.

   ,      
  ,     
  .

=cut
