package IMPL::Security;
require IMPL::Security::Context;
require IMPL::Security::Rule::RoleCheck;

our @rules = (
	\&IMPL::Security::Rule::RoleCheck::SatisfyAll
);

our $authority = undef;

sub AccessCheck {
	my ($self, $object, $desiredAccess, $context) = @_;
	
	$context ||= IMPL::Security::Context->contextCurrent;
	
	$_->() or return 0 foreach @{$self->Rules};
	
	return 1;
}

sub Take {
	my ($self,$principal,$refRoles) = @_;
	
	die new IMPL::NotImplementedException();
}

sub MakeContext {
	my ($this,$principal,$refRoles,$auth) = @_;
	
	return new IMPL::Security::Context(
		principal => $principal,
		rolesAssigned => $refRoles,
		auth => $auth
	);
}

sub Rules {
	return \@rules;
}

sub authority {
	return $authority;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security> -        .

=head1 SINOPSYS

=begin code

use IMPL::Security;

my Method {
	my $this = shift;
	
	# access check in the current context, using standard configuration
	IMPL::Security->AccessCheck($this,'Method') or die new IMPL::AccessDeniedException("Access is denied");
	
	#some more results 
}

my DelegationMethod {
	
	my $this = shift;
	
	#forced delegation 
	my $delegatedContext = IMPL::Security::Context->new(
		principal => IMPL::Security::Principal->new(
			name => 'suser'
		),
		rolesAssigned => ['administrator']
	)
	
	my $result;
	
	$delegatedContext->Impersonate(sub{
		$result = $this->Method();
	});
	
	return $result;
}

my SafeDelegationMethod {
	
	my $this = shift;
	
	my $delegatedContext = IMPL::Security->Take( suser => 'administrator' );
	
	my $result;
	
	$delegatedContext->Impersonate(sub{
		$result = $this->Method();
	});
	
	return $result;
}

=end code

=head1 DESCRIPTION

   ,     
  .

 ,     , 
,     ,  
     .

        ,
   ,   .

=head1 MEMBERS

=over

=item C<AccessCheck($object,$desiredAccess,$context)>

.       ,    .

=over

=item C<$object>

 .

=item C<$desiredAccess>

  .

=item C<$context>

 ,   ,    C<< IMPL::Security::Context->contextCurrent >>

=item C<returns>

C<true | false> -  

=back

=item C<MakeContext($principal,$role,$auth)>

  ,    .

=over

=item C<$principal>

 

=item C<$role>

     

=item C<$auth>

 

=back

=item C<Take($principal,$role)>

.      .    
  .     .

=over

=item C<$principal>

     C<IMPL::Security::Principal>.

=item C<$role>

     ,      ,  .

=item C<returns>

  .

=back

=item C<Rules()>

       .  
,     .      
   .

=begin code

package MySecurity;

use parent qw(IMPL::Security);

sub Rules {
	return [
		\&Rule1,
		\&Rule2,
		#...
	]
}

=end code

=item C<[static,get] authority>

,      .  ,  ,
          .

=back

=cut