package IMPL::DOM::Node;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Serializable IMPL::Object::Autofill);

use IMPL::Object::List;
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use Scalar::Util qw(weaken);

use IMPL::Exception;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public _direct property nodeName => prop_get | owner_set;
    public _direct property isComplex => { get => \&_getIsComplex } ;
    public _direct property nodeValue => prop_all;
    public _direct property childNodes => { get => \&_getChildNodes };
    public _direct property parentNode => prop_get ;
    private _direct property _propertyMap => prop_get ;
}

sub CTOR {
    my ($this,$name) = @_;
    
    $this->nodeName($name) or die new IMPL::InvalidArgumentException("A name is required");
}

sub insertNode {
    my ($this,$node,$pos) = @_;
    
    die new IMPL::InvalidOperationException("You can't insert the node to itselft") if $this == $node;
    
    $node->{$parentNode}->removeNode($node) if ($node->{$parentNode});
    
    $this->childNodes->InsertAt($pos,$node);
    
    $node->_setParent( $this );
    
    return $node;
}

sub _getChildNodes {
    my ($this) = @_;
    
    $this->{$childNodes} = new IMPL::Object::List() unless $this->{$childNodes};
    $this->{$childNodes};
}

sub removeNode {
    my ($this,$node) = @_;
    
    if ($this == $node->{$parentNode}) {
        $this->childNodes->RemoveItem($node);
        $node->{$parentNode} = undef;
        return $this;
    } else {
        die new IMPL::InvalidOperationException("The specified node isn't belong to this node");
    }
}

sub removeAt {
    my ($this,$pos) = @_;
    
    if ( my $node = $this->childNodes->RemoveAt($pos) ) {
        $node->{$parentNode} = undef;
        return $node;
    } else {
        return undef;
    }
}

sub selectNodes {
    my ($this,$name) = @_;
    
    my @result = grep $_->nodeName eq $name, @{$this->childNodes};
    
    return wantarray ? @result : \@result;
}

sub _getIsComplex {
    $_[0]->childNodes->Count ? 1 : 0;
}

sub _setParent {
    my ($this,$parentNode) = @_;
    
    $this->{$parentNode} = $parentNode;
    weaken($this->{$parentNode});
}

sub text {
    my ($this) = @_;
    
    join '', $this->nodeValue, map $_->nodeValue, @{$this->childNodes};
}

sub Property {
    my $this = shift;
    my $name = shift;
    
    if (@_) {
        # set
        return $this->{$_propertyMap}{$name} = shift;
    } else {
        return $this->{$_propertyMap}{$name};
    }
}

1;
