package IMPL::Web::QueryHandler::PageFormat;
use base qw(IMPL::Web::QueryHandler IMPL::Object::Autofill);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use IMPL::Web::TT::Document;
use IMPL::Security::Context;
use File::Spec;
use Error qw(:try);

BEGIN {
	public property templatesCharset => prop_all;
	public property templatesBase => prop_all;
	public property defaultTarget => prop_all;
	public property pathinfoPrefix => prop_all;
}

sub CTOR {
	my ($this) = @_;
	
	$this->templatesCharset('utf-8') unless $this->templatesCharset;
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $doc = new IMPL::Web::TT::Document();
	
	try {

		$this->templatesBase($ENV{DOCUMENT_ROOT}) unless $this->templatesBase;
		
		my $pathInfo = $ENV{PATH_INFO};
		my $prefixRoot = "";
		if (my $rx = $this->pathinfoPrefix) {
			$pathInfo =~ s/($rx)//;
			$prefixRoot = $1 if $1;
		}
		local $ENV{PATH_INFO} = $pathInfo || $this->defaultTarget;
		
		my @path = split /\//, ($ENV{PATH_INFO} || '') or die new IMPL::Exception("PATH_INFO is empty and no defaultTarget specified" );
		
		$doc->LoadFile ( File::Spec->catfile($this->templatesBase,@path), $this->templatesCharset, $this->templatesBase );
		$doc->AddVar( result => $nextHandler->() );
		$doc->AddVar( absoluteUrl => sub { "$prefixRoot/$_[0]" } );
		{
			local $@;
			$doc->AddVar( user => IMPL::Security::Context->current->principal );
			$doc->AddVar( session => IMPL::Security::Context->current );
			warn $@ if $@;
		}
		
		$action->response->contentType('text/html');
		my $hOut = $action->response->streamBody;
		print $hOut $doc->Render();
	} finally {
		$doc->Dispose;
	};
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::QueryHandler::PageFormat> -     HTML ,   .

=head1 SYNOPSIS

   

=begin code xml

<handlersQuery type="IMPL::Object::List">
	<item type="IMPL::Web::QueryHandler::PageFormat">
		<charsetTemplates>utf-8</charsetTemplates>
	</item>
</handlersQuery>

=end code xml



=begin code

my $app = new IMPL::Web::Application();
$app->handlersQuery->Add(
	new IMPL::Web::QueryHandler::PageFormat( charsetTemplates=> 'utf-8' );
);

=end

=head1 DESCRIPTION

    .  ,    
 C<ENV{PATH_INFO}>     C<templatesBase>.

  C<IMPL::Web::QueryHandler>   
     C<Process>.

C<Serializable>

=head1 MEMBERS

=over

=item C<CTOR(%props)>

     .

=item C<[get,set] templatesCharset>

 .   utf-8.

=item C<[get,set] templatesBase>

    .

=item C<[override] Process($action,$nextHandler)>

,  C<IMPL::Web::QueryHandler->Process>    
  .

=back

=cut