package IMPL::DOM::Document;
use strict;
use warnings;

use base qw(IMPL::DOM::Node);

__PACKAGE__->PassThroughArgs;

sub document {
    return $_[0];
}

sub Create {
    my ($this,$nodeName,$class,$refProps) = @_;
    
    if ( ref $class eq 'HASH' ) {
    	$refProps = $class;
    	$class = undef;
    }
    
    $class ||= typeof IMPL::DOM::Node;
    $refProps ||= {};
    
    delete $refProps->{nodeName};
    
    die new IMPL::Exception("class is not specified") unless $class;
    return $class->new(
        nodeName => $nodeName,
        document => $this,
        %$refProps
    );
}

{
    my $empty;
    sub Empty() {
        return $empty ? $empty : $empty = __PACKAGE__->new(nodeName => 'Empty');
    }
}

1;
__END__

=pod

=head1 NAME

C<IMPL::DOM::Document> DOM .

=head1 DESCRIPTION

,     ,   
    . ..  C<IMPL::DOM::Navigator::Builder>
   .

=head1 SYNOPSIS

=begin code

package MyDocument;
use base qw(IMPL::DOM::Document);

sub Create {
	my $this = shift;
	my ($name,$class,$hashProps) = @_;
	
	if ($class eq 'Info') {
		return MyInfo->new($name,$hashProps->{date},$hashProps->{description});
	} else {
		# leave as it is
		return $this->SUPER::Create(@_);
	}
}

=end code

=head1 METHODS

=over

=item C< Create($nodeName,$class,$hashProps) >

  .         .

=begin code

sub Create {
	my ($this,$nodeName,$class,$hashProps) = @_;
	
	return $class->new (
		nodeName => $nodeName,
		document => $this,
		%$hashProps
	);
}

=end code

=back

=cut
