package IMPL::Code::MethodCache;
use strict;
use IMPL qw(Debug);

my %cachedMethods;

sub dbgBuildCachedMethod {
	my ($class,$method,$prefix,$mappers)= @_;
	
	no strict 'refs';
	
	$prefix ||= 'call';
	
	my $proxyMethod = "$prefix$method";
	
	die new IMPL::Exception("A proxy method already exists") if *{"${class}::$proxyMethod"}{CODE};
	
	my @methodCache = cacheMethod($class,$method,$mappers);
	
	*{"${class}::$proxyMethod"} = sub {
		$_->(@_) foreach @methodCache;
	}
}

sub cacheMethod {
	my ($class,$method,$mappers) = @_;
}

1;