package IMPL::Resources;
use strict;
use warnings;

our $Encoding ||= 'utf-8';
our %Files;

my %Data;


    foreach my $group (keys %Files) {
        $Data{$group} = ParseResource($Files{$group});
    }

sub findFile {
    my ($fname) = @_;
    
    foreach my $dir (',',@INC) {
        my $fullfname = "$dir/$fname";
        return $fullfname if -f $fullfname;
    }
    
    return $fname;
}
    
sub ParseResource {
    my ($fname) = @_;
    
    open my $hRes, "<:encoding($Encoding)", findFile($fname) or die "Failed to open file $fname: $!";
    
    my %Map;
    my $line = 1;
    while (<$hRes>) {
        chomp;
        $line ++ and next if /^\s*$/;
        
        if (/^(\w+)\s*=\s*(.*)$/) {
            $Map{$1} = $2;
        } else {
            die "Invalid resource format in $fname at $line";
        }
        $line ++;
    }
    
    return \%Map;
}

sub import {
    my ($class,@groups) = @_;
    my $caller = caller;
    my %merged = map %{$Data{$_} || {} }, @groups;
    
    no strict 'refs';
    foreach my $item ( keys %merged ) {
        *{"${caller}::ids_$item"} = sub { sprintf($merged{$item},@_) } 
    }
}

1;
