package IMPL::Text::Parser::Chunk;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Autofill);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

use constant {
    OP_REGEXP => 1,
    OP_STRING => 2,
    OP_REFERENCE => 3,
    OP_CHUNK => 4,
    OP_SWITCH => 5,
    OP_REPEAT => 7
};

BEGIN {
    public _direct property chunkName => prop_get;
    public _direct property opStream => prop_get;
}

sub Regexp {
    my ($this,$rx) = @_;
    
    if (ref $rx eq 'Regexp') {
        
    } elsif (not ref $rx) {
        $rx = q/$rx/;
    } else {
        die new IMPL::InvalidArgumentException('A regular expression required');
    }
    
    push @{$this->{$opStream}}, [OP_REGEXP, $rx];
}

sub String {
    my ($this,$str) = @_;
    
    die new IMPL::InvalidArgumentException("A simple value is required") if ref $str;
    
    push @{$this->{$opStream}}, [OP_STRING, $str];
}

sub Reference {
    my ($this,$ref) = @_;
    
    die new IMPL::InvalidArgumentException("A simple value is reqiured") if ref $ref;
    
    push @{$this->{$opStream}}, [OP_REFERENCE, $ref];
}

sub Chunk {
    my ($this,$chunk) = @_;
    
    die new IMPL::InvalidArgumentException unless UNIVERSAL::isa($chunk,'IMPL::Text::Parser::Chunk');
    
    push @{$this->{$opStream}}, [OP_CHUNK, $chunk];
}

sub Switch {
    my $this = shift;
    
    push @{$this->{$opStream}}, [OP_SWITCH, @_];
}

sub Repeat {
    my ($this,$chunk,$min,$max) = @_;
    
    die new IMPL::InvalidArgumentException unless UNIVERSAL::isa($chunk,'IMPL::Text::Parser::Chunk');
    
    push @{$this->{$opStream}}, [OP_REPEAT, $chunk, $min, $max ];
}

1;

__END__

=pod

=head1 DESCRIPTION
  

=head1 MEMBERS

=level

=item C<<$obj->>>

=back

=cut
