package IMPL::require;
use Scalar::Util qw(set_prototype);
use strict;

sub import {
	my ($self, $aliases) = @_;
	
	return unless $aliases;
	
	die "A hash reference is required" unless ref $aliases eq 'HASH';
	
	my $caller = caller;
	
	no strict 'refs';
	
	while( my ($alias, $class) = each %$aliases ) {
		(my $file = $class) =~ s/::|'/\//g;
		require "$file.pm";
		
		*{"${caller}::$alias"} = set_prototype(sub {
            $class
        }, '');
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::require> загружает и назначет псевдонимы модулям.

=head1 SYNOPSIS

=begin code

use IMPL::require {
	TFoo => 'My::Nested::Package::Foo',
	FS => 'File::Spec'
};

my $obj = My::Nested::Package::Foo->new('foo');
$obj = TFoo->new('foo'); # ditto

FS->catdir('one','two','three');

=end code

=head1 DESCRIPTION

Загружает модули с помощью C<require> и создает константы которые возвращаю полное имя модуля.


=cut