package IMPL::Web::Handler::TTView;
use strict;

use IMPL::lang qw(:declare :constants);
use IMPL::declare {
	base => {
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	}
};

BEGIN {
	public property contentType => PROP_GET | PROP_OWNERSET;
	public property templates => PROP_GET | PROP_OWNERSET;
}

sub Invoke {
	my ($this,$action,$next) = @_;
	
	my $result = $next ? $next->($action) : undef;
	
	my $doc = $this->templates->document(
        'default',
        {
        	data => $result,
        	action => $action,
        	app => $action->application
        }
    );
	
	my $hout = $action->response->streamBody;
    
    print $hout $doc->Render();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Handler::TTView> - использует шаблоны для построения представления.

=head1 SYNOPSIS

=begin code xml

<view type="HASH">
    <item extname="@My::Data::Product">product/info</item>
    <catalog>
    <catalog>
</view>

=end code xml

=head1 DESCRIPTION

Подбирает шаблон для представления результата, полученного при выполнении следующего обработчика. При
выборе используется принцип похожий на селекторы C<CSS>, основывающийся на именах ресурсов и их типах
данных.

=head1 SELECTORS

=begin text

[url-template] [class] => template

shoes/      => product/list
{action:*.} @My::Data::Product => product/{action}

=end text



=cut

