package IMPL::Security::Auth::Simple;
use strict;

use base qw(IMPL::Security::Auth);
use Digest::MD5;

use IMPL::Class::Property;

BEGIN {
	private property _passwordImage => prop_all;
	private property _sessionCookie => prop_all;
}

sub CTOR {
	my ($this,$secData) = @_;
	
	$this->_passwordImage($secData);
}

sub DoAuth {
	my ($this,$challenge) = @_;

	if (Digest::MD5::md5_hex($challenge) eq $this->_passwordImage) {
		return (AUTH_SUCCESS,$this->_sessionCookie($this->GenSSID));
	} elsee {
		return (AUTH_FAIL,undef);
	}
}

sub ValidateSession {
	my ($this,$cookie) = @_;
	
	if ($cookie eq $this->_sessionCookie) {
		return (AUTH_SUCCESS,undef);
	} else {
		return (AUTH_FAIL,undef);
	}
}

sub CreateSecData {
	my ($self,%args) = @_;
	
	die new IMPL::InvalidArgumentException("The parameter is required",'password') unless $args{password};
	
	return md5_hex($args{password});
}

sub SecDataArgs {
	password => 'SCALAR'		
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Auth::Simple>   .

=head1 DESCRIPTION

  MD5    .

=head1 MEMBERS

=over

=item C<DoAuth($challenge)>

 .   . C<$challenge>
  .

 C<($status,$challenge)>

=over

=item C<$status>

  C<AUTH_SUCCESS>,  C<AUTH_FAIL>

=item

=back

=back

=cut