use strict;
package IMPL::SQL::Schema::Column;
use base qw(IMPL::Object IMPL::Object::Autofill IMPL::Object::Clonable);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property Name => prop_get;
    public _direct property Type => prop_get;
    public _direct property CanBeNull => prop_get;
    public _direct property DefaultValue => prop_get;
    public _direct property Tag => prop_get;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    $this->{$Name} or die new IMPL::InvalidArgumentException('a column name is required');
    $this->{$CanBeNull} = 0 if not exists $this->{$CanBeNull};
    UNIVERSAL::isa($this->{$Type},'IMPL::SQL::Schema::Type') or die new IMPL::InvalidArgumentException('a type is required for the column',$this->{$Name});
}

sub isEqualsStr {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a eq $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isEquals {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a == $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isSame {
    my ($this,$other) = @_;
    
    return ($this->{$Name} eq $other->{$Name} and $this->{$CanBeNull} == $other->{$CanBeNull} and isEqualsStr($this->{$DefaultValue}, $other->{$DefaultValue}) and $this->{$Type}->isSame($other->{$Type}));
}

1; 
