package IMPL::DOM::Schema::ComplexNode;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Node);
use IMPL::Class::Property;

BEGIN {
    public property content => {
        get => \&_getContent,
        set => \&_setContent
    }
}

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {my %args = @_; $args{nodeName} ||= 'ComplexNode'; %args }
);

sub _getContent {
    $_[0]->firstChild;
}

sub _setContent {
    $_[0]->firstChild($_[1]);
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    map $_->Validate($node,$ctx), @{$this->childNodes};
}

1;

__END__

=pod

=head1 DESCRIPTION

  .    ,  
.

        ..
       , . C<content>

=head2 PROPERTIES

=over

=item C<content>

 ,    C<IMPL::DOM::Schema::NodeSet> 
C<IMPL::DOM::Schema::NodeList>,        .
       .

=back

=cut
