package IMPL::Class::MemberInfo;
use strict;
use IMPL::_core::version;
use base qw(IMPL::Object::Accessor);

require IMPL::Exception;
require IMPL::Class::Member;

__PACKAGE__->mk_accessors(
    qw(
        Name
        Access
        Virtual
        Class
        Frozen
        Implementor
        Attributes
    )
);
__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    die new IMPL::Exception('The name is required for the member') unless $this->Name;
    die new IMPL::Exception('The class is required for the member') unless $this->Class;
    
    $this->Attributes({}) unless defined $this->Attributes;
    $this->Frozen(0);
    $this->Virtual(0) unless defined $this->Virtual;
    $this->Access(3) unless $this->Access;
}

sub Implement {
    my ($this) = @_;
    $this->Implementor->Make($this);
    $this->Frozen(1);
    $this->Class->set_meta($this);
    return;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Class::MemberInfo> -    .

=head1 DESCRIPTION

        C<IMPL::Class::PropertyInfo>, C<IMPL::Class::MethodInfo>  
   .

    C<IMPL::Object::Accessor>         .

=head1 MEMBERS

=over

=item C<[get,set] Name>

 .

=item C<[get,set] Access>

Default public.

  ( public | private | protected )

=item C<[get,set] Virtual>

Default false.

 .

=item C<[get,set] Class>

 
        
=item C<[get,set] Frozen>

   

=item C<[get,set] Attributes>

 

=item C<Implement()>

 C<Frozen>  C<1>,    .

   ,      
   (,     ).

=back

=cut
