package Form::Item;
use strict;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Parent => ACCESS_READ;
    DeclareProperty Form => ACCESS_READ;
    DeclareProperty Id => ACCESS_READ;
    DeclareProperty Attributes => ACCESS_ALL;
}

sub CTOR {
    my ($this,$id,$form,$parent,$attrib) = @_;
    
    $this->{$Id} = $id or die new Exception('An Id i required for the form item');
    $this->{$Form} = $form or die new Exception('A form is required for the form item');
    $this->{$Parent} = $parent;
    $this->{$Attributes} = $attrib || {};
}

sub Name {
    my ($this) = @_;
    return $this->{$Id}->Name;
}

sub Navigate {
    my ($this,$ItemId) = @_;
    
    $ItemId or die new Exception("An item id is undefined");
    
    return $this->NavigatePath([$ItemId->ToNAVPath]);
}

sub Item {
    my ($this,$strId) = @_;
    
    return $this->Navigate($this->Form->MakeItemId($strId,$this));
}

sub NavigatePath {
    my ($this,$refPath) = @_;
    
    my $ItemId = shift @$refPath or die new Exception("An item id is undefined");
    my $current;
    
    if ($ItemId->isa('Form::ItemId::Prev')) {
        $this->{$Parent} or die new Exception('Can\'t navigate to upper level');
        $current = $this->{$Parent};
    } elsif ($ItemId->isa('Form::ItemId::Root')) {
        $current = $this->{$Form};
    } else {
        $current = $this->ResolveItem($ItemId);
    }
    
    if (@$refPath > 0) {
        die new Exception('The item not found', $ItemId->Canonical) if not $current;
        return $current->NavigatePath($refPath);
    } else {
        return $current;
    }
}

sub ResolveItem {
    my ($this,$ItemId) = @_;
    
    die new Exception('Item not found',$ItemId->Name);
}

sub Dispose {
    my ($this) = @_;
    
    undef %$this;
    
    $this->SUPER::Dispose;
}


1;
