package IMPL::Web::Security::Session;
use strict;
use parent qw();

use IMPL::Const qw(:prop);
use IMPL::declare {
    base => [
        'IMPL::Security::AbstractContext' => '@_'
    ]
};

push @{__PACKAGE__->abstractProps}, sessionId => PROP_RW;

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security::Session> - Сессия пользователя.

=head1 SINOPSYS

=begin code

# define a custom session for the application

package App::Session;
use parent qw(IMPL::Web::Security::Session);

use IMPL::Class::Property;

BEGIN {
    public property transactionId => prop_all;
}

=end code

=head1 DESCRIPTION

C<use parent qw(IMPL::Security::Context)>

Представляет собой контекст безопасности, имеет идентификатор. Является базовым классом
для расширения дополнительными атрибутами.

=head1 MEMBERS

=over

=item C<[get] sessionId>

Идентификатор сессии

=back

=cut
