package IMPL::Web::RestContract;
use strict;

use IMPL::lang qw(:declare);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		InvalidOpException => '-IMPL::InvalidOperationException',
		ForbiddenException => 'IMPL::Web::ForbiddenException',
		TRestResource => 'IMPL::Web::Application::RestResource',
		RestBaseResource => 'IMPL::Web::Application::RestBaseResource',
	},
	base => {
		'IMPL::Transform' => sub { my %args = @_; $args{resources} },
		'IMPL::Object::Serializable' => undef
	}
};

sub CTOR {
	my ($this) = @_;
	
	$this->templates->{-plain} = sub { die ForbiddenException->new(); };
	$this->templates->{-default} = sub { die ForbiddenException->new(); };
	$this->templates->{&RestBaseResource} = sub { $_[1] };
}

sub ProcessTemplate {
	my ($this,$t,$obj,$props) = @_;
	
	$props ||= {};
	
	if (ref $t eq 'HASH') {
		my $factory = $t->{factory} || TRestResource;
		return $factory->new(%$t, target => $obj, contract => $this, %$props);
	} elsif (ref $t eq 'CODE') {
		return $this->$t($obj,$props);
	} else {
		die InvalidOpException->new();
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::RestContract> Описывает правила публикации ресурсов.

=head1 SYNOPSIS



=begin code

=end code 

=head1 DESCRIPTION

Контракт представляет собой отображение модели предметной области на модель
ресурсов. Контракт описывает дерево ресурсов начиная с корневого ресурса,
и далее.

Ресурсы состоят из нескольких описаний: C<ResourceContract>, C<OperationContract>
которые описываю отображение самих ресурсов и операций над ресурсами в предметную
область.

C<ResourceContract> представляет собой описание того, какой ресурс и с какими
параметрами должен быть создан. Например, может быть создан ресурс публикующий
методы родительского ресурса, или же ресурс может слжить контроллером для
работы с объектами предметной области.

C<OperationContract> описывает связь между методом объекта предметной области и
операцией возможной над ресурсом. Операция сводится к преобразованию запроса в
аргументы метода, затем вызову метода и преобразованию результата в ответ на запрос.

Ответ на запрос может быть как сформирован полностью в виде C<HTTP> ответа, так и
в виде объекта, который будет в дальнейшем обработан нижележащими обработчиками
приложения. 
 


=cut