package IMPL::Config::Descriptor;
use strict;
use IMPL::Exception();
use Scalar::Util qw(looks_like_number);

sub ACTIVATE_SINGLETON() { 1 }
sub ACTIVATE_CONTAINER() { 2 }
sub ACTIVATE_HIERARCHY() { 3 }
sub ACTIVATE_CONTEXT()   { 4 }
sub ACTIVATE_CALL()      { 5 }

my %activateNames = (
    singleton => ACTIVATE_SINGLETON,
    container => ACTIVATE_CONTAINER,
    hierarchy => ACTIVATE_HIERARCHY,
    context   => ACTIVATE_CONTEXT,
    call      => ACTIVATE_CALL
);

my %activateNamesLookup = reverse %activateNames;

sub Activate {
    my ( $this, $context ) = @_;
    die IMPL::NotImplementedException->new();
}

sub services {
    
}

sub GetName {
    die IMPL::NotImplementedException->new();
}

sub ParseActivation {
    my $val = pop @_;

    return ACTIVATE_CALL unless $val;

    return grep( $_ == $val,
        ACTIVATE_SINGLETON,
        ACTIVATE_CONTAINER,
        ACTIVATE_HIERARCHY,
        ACTIVATE_CONTEXT, ACTIVATE_CALL ) ? $val : ACTIVATE_CALL
      if looks_like_number($val);

    return $activateNames{ lc($val) } || ACTIVATE_CALL;
}

sub ActivationToString {
    my $val = pop @_;

    return ( $val && $activateNamesLookup{$val} ) || '';
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Config::Descriptor> - the abstract base types for the service descriptors 

=head1 SYNOPSIS

=begin code

package MyDescriptor;

use IMPL::declare {
	base => {
		'IMPL::Config::Descriptor' => '@_'
	}
};

sub Activate {
	my ($this,$context) = @_;
	
	my $service = $context->GetService('service');
	my 
	 
}

=end code

=head1 MEMBERS

=head1 SEE ALSO

=over

=item * L<ReferenceDescriptor> - describes a reference to the service

=item * L<ServiceDescriptor> - descibes a service factory

=item * L<ValueDescriptor> - describes a value

=back

=cut
