package IMPL::Web::View::TTContext;
use strict;
use Template::Base;

use IMPL::lang qw(is);
use IMPL::declare {
	require => [
	   Document => '-Template::Document'
	],
	base => {
		'Template::Context' => '@_'
	}
};

sub clone {
	my $this = shift;
	
	$this->localise();	

	my $args = { %{$this} };

	$this->delocalise();
	
	my $class = typeof($this);
	
    delete $args->{CONFIG};
    
    return $class->new($args);
}

sub base {
	my $this = shift;
	
	return @_ ? $this->stash->set('base', @_) : $this->stash->get('base'); 
}

sub tt_ext {
	my $this = shift;
	
	return @_ ? $this->stash->set('tt_ext', @_) : $this->stash->get('tt_ext');
}

sub find_template {
	my ($this,$name,@inc) = @_;
	
	push @inc, "";
	my $ext = $this->tt_ext || "";
    
	foreach my $dir (@inc) {
		my $file = "$dir/$name$ext";
		my $tt = eval { $this->template($file) };
		
		return {
			# if we load a block then we should use the current base directory
			base => is($tt,Document) ? $dir : $this->base,
			isDocument => is($tt,Document),
			name => $name,
			file => $file,
			template => $tt
		} if $tt;
	}
	
	$this->throw(Template::Constants::ERROR_FILE, "$name: not found");
}

sub require {
	my ($this,$name) = @_;
	
	return $this->stash->get([ 'require', [$name] ]);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTContext> - доработанная версия контекста

=head1 DESCRIPTION

Расширяет функции C<Template::Context>

=begin plantuml

@startuml

object SharedContext {
    document
    globals
}

object DocumentContext {
    base
    extends
}

object ControlContext {
    base
    extends
}

SharedContext o-- DocumentContext 
SharedContext o-- ControlContext 

Document -- DocumentContext
Control - ControlContext

Loader . SharedContext: <<creates>>
Loader . Document: <<creates>>
Loader -up- Registry

@enduml

=end plantuml

=head1 MEMBERS

=head2 C<[get,set]base>

Префикс пути для поиска шаблонов

=head2 C<template($name)>

Сначала пытается загрузить шаблон используя префикс C<base>, затем без префикса.

=head2 C<clone()>

Создает копию контекста, при этом C<stash> локализуется, таким образом
клонированный контекст имеет собственное пространство имен, вложенное в
пространство родительского контекста.

=cut