package IMPL::Config::Resolve;
use strict;
use parent qw(IMPL::Object IMPL::Object::Serializable);

use IMPL::Class::Property;
use IMPL::Exception;
use Carp qw(carp);

BEGIN {
    public property path => prop_all|prop_list;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    my $list = $this->path;
    
    while(my $name = shift ) {
        my $args = shift;
        $list->Append({ method => $name, (defined $args ? (args => $args) : ()) });
    }
    
    #die new IMPL::InvalidArgumentException("The argument is mandatory","path") unless $this->path->Count;
}

sub Invoke {
    my ($this,$target,$default) = @_;
    
    my $result = $target;
    $result = $this->_InvokeMember($result,$_) || return $default foreach $this->path;
    
    return $result;
}

sub _InvokeMember {
    my ($self,$object,$member) = @_;
    
    my $method = $member->{method};
    
    local $@;
    return eval {
        ref $object eq 'HASH' ?
            $object->{$method}
            :
            $object->$method(
                exists $member->{args} ?
                    _as_list($member->{args})
                    :
                    ()
            )
    };
}

sub save {
    my ($this,$ctx) = @_;
    
    $ctx->AddVar($_->{method},$_->{args}) foreach $this->path;
}

sub _as_list {
    ref $_[0] ?
        (ref $_[0] eq 'HASH' ?
            %{$_[0]}
            :
            (ref $_[0] eq 'ARRAY'?
                @{$_[0]}
                :
                $_[0]
            )
        )
        :
        ($_[0]);
}

1;
