#!/usr/bin/perl
use strict;

use IMPL::require {
	TTContext => 'IMPL::Web::View::TTContext'
};

my $ctx = TTContext->new({
	INCLUDE_PATH => './Resources/view',
	INTERPOLATE => 1,
	RECURSION => 1000
});

warn $ctx->load_templates->[0]->include_path->[0];

print $ctx->invoke_environment(sub {
	return shift->render(
	    'product/view',{
			model => {
				name => 'debugger',
				manufature => {
					name => 'DEBUGGERS INC',
					address => [
					     {
					     	coutry => 'Russuia',
					     	city => 'Moscow'
					     },
					     {
					     	country => 'GB',
					     	city => 'Essex'
					     }
					]
				}
			}
	   }
    );
}, {
	base => 'site',
	includes => [
	   'packages'
	],
	tt_ext => 'tt'
});
   
