package IMPL::DOM::Schema::SwitchNode;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::AnyNode);
use IMPL::Class::Property;
require IMPL::DOM::Schema::ValidationError;
use IMPL::DOM::Property qw(_dom);

our %CTOR = (
    'IMPL::DOM::Schema::AnyNode' => sub {
        my %args = @_;
        
        $args{nodeName} ||= 'SwitchNode';
        
        %args;
    }
);

BEGIN {
    public _dom property messageNoMatch => prop_all;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageNoMatch($args{messageNoMatch} || 'A node %node.nodeName% isn\'t expected in the %parent.path%');
}

sub Validate {
    my ($this,$node,$ctx) = @_;
        
    if ( my ($schema) = $this->selectNodes(sub {$_[0]->name eq $node->nodeName} ) ) {
        return $schema->Validate($node);
    } else {
        return new IMPL::DOM::Schema::ValidationError(
            node => $node,
            source => $this,
            message => $this->messageNoMatch
        );
    }
}

1;

__END__

=pod

=head1 DESCRIPTION

Представляет узел, который может быть одним из узлов, которые лежат внутри него.
Это более строгий вариант C<IMPL::DOM::Schema::AnyNode>.

=cut
