#!/usr/bin/perl
use strict;

use YAML::XS;
$YAML::XS::DumpCode = 1;

my $conf = {
	'@include' => [qw(security view)],
	runtime => {
		type => 'IMPL::Web::Application',
		params => {
			handlers => {depdendency => 'filters'}
		} 
	},
	filters => [
		{ type => 'IMPL::Web::CookieAuth' },
		{ type => 'IMPL::Web::Security' },
		{ type => 'IMPL::Web::LocaleHandler',
			params => {
				locales => [
					'en-US',
					'ru-RU'
				],
				default => 'en-US'
			}
		},
		{ type => 'IMPL::Web::ContentNegotiation' },
		{ type => 'IMPL::Web::RestController' }
	],
	custom => {
		factory => sub { return "hi!" }
	}
};

print Dump($conf);

1;