package Test::DOM::Navigator;
use base qw(IMPL::Test::Unit);

__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(test failed);
use IMPL::DOM::Navigator;
use IMPL::DOM::Navigator::SchemaNavigator;
use IMPL::DOM::Node;
use IMPL::DOM::Schema;
use IMPL::Class::Property;

BEGIN {
    public property doc => prop_all;
}

sub CTOR {
    my ($this) = @_;
    
    $this->doc(
        IMPL::DOM::Node->new(nodeName => 'root')->appendRange(
            IMPL::DOM::Node->new(nodeName=> 'age', nodeValue => 21),
            IMPL::DOM::Node->new(nodeName=> 'address')->appendRange(
                IMPL::DOM::Node->new(nodeName=>'city', nodeValue=>'moscow'),
                IMPL::DOM::Node->new(nodeName=>'street', nodeValue=>'main'),
                IMPL::DOM::Node->new(nodeName=>'phone',nodeValue=>'123-456'),
            ),
            IMPL::DOM::Node->new(nodeName=> 'address')->appendRange(
                IMPL::DOM::Node->new(nodeName=>'city', nodeValue=>'San Francisco'),
                IMPL::DOM::Node->new(nodeName=>'street', nodeValue=>'Libertador'),
            ),
            IMPL::DOM::Node->new(nodeName=> 'contacts')->appendRange(
                IMPL::DOM::Node->new(nodeName=>'phone',nodeValue=>'123-123'),
                IMPL::DOM::Node->new(nodeName=>'phone',nodeValue=>'1-233-434-34-54'),
                IMPL::DOM::Node->new(nodeName=>'email',nodeValue=>'some@mail.none')
            )
            
        )
    );
}

test Creation => sub {
    my ($this) = @_;
    
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    
    my $obj = new IMPL::DOM::Navigator($doc) or failed "Failed to create instance" ;
};

test Navigate => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    my $navresult = $navi->Navigate("Child");
    
    failed ("Navigate retuned unexpected result", "Recieved: $navresult", "Expected: $child") if $child != $navresult;
    my $curr = $navi->Current;
    failed ("Current node has a wrong value","Current: $curr","Expected: $child") if $child != $curr;
};

test PathToString => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    $navi->Navigate("Child");
    
    my $expected = "root/Child";
    my $res = $navi->PathToString;
    failed("Unexpected PathToString result","Recieved: $res","Expected: $expected") if $res ne $expected;
};

test Back => sub {
    my $doc = new IMPL::DOM::Node(nodeName => 'root');
    my $child = $doc->insertNode(
        new IMPL::DOM::Node(
            nodeName => 'Child'
        )
    );
    
    my $navi = new IMPL::DOM::Navigator($doc);
    $navi->Navigate("Child");
    my $navresult = $navi->Back;
    
    failed ("Back() retuned unexpected result", "Recieved: $navresult", "Expected: $doc") if $doc != $navresult;
    my $curr = $navi->Current;
    failed ("Current node has a wrong value","Current: $curr","Expected: $doc") if $doc != $curr;
};

test selectNodes1 => sub {
    my ($this) = @_;
    
    my $navi = new IMPL::DOM::Navigator($this->doc);
    my @result = $navi->selectNodes('contacts','phone');
    failed "Expected to get two entries, but got:",map($_->nodeName,@result) unless @result == 2;
};

test selectNodes2 => sub {
    my ($this) = @_;
    
    my $navi = new IMPL::DOM::Navigator($this->doc);
    my @result = $navi->selectNodes(undef,'phone');
    failed "Expected to get three entries, but got:",map($_->nodeName,@result) unless @result == 3;
};

test FetchDoeachState => sub {
    my ($this) = @_;
    
    my $navi = new IMPL::DOM::Navigator($this->doc);
    
    $navi->Navigate(undef,'phone');
    
    $navi->saveState();
    
    my @result;
    doeach $navi sub {
        push @result,$_;
    };
    
    failed "Expected to get three nodes, but got: ", map($_->nodeName,@result) unless @result == 3;
    
    $navi->restoreState();
    @result = ();
    
    push @result, $_ while fetch $navi;
    
    failed "Expected to get three nodes, but got: ", map($_->nodeName,@result) unless @result == 3;
};

test NavigateSchema => sub {
    my $navi = new IMPL::DOM::Navigator::SchemaNavigator(IMPL::DOM::Schema->MetaSchema);
    
    my $root = $navi->NavigateName('schema') or failed "Failed to navigate to the root element";
    
    $navi->saveState;
    $navi->NavigateName('Node') or failed "Failed to navigate to a simple node";
    $navi->restoreState;
    
    failed "Can't navigate from simple node" if $navi->NavigateName('Property');
    
    $navi->NavigateName('ComplexType') or failed "Failed to navigate to a complex node";
    $navi->NavigateName('NodeSet') or failed "Failed to navigate to NodeSet";
    $navi->SchemaBack();
    $navi->NavigateName('NodeList') or failed "Failed to navigate to NodeList";
    $navi->NavigateName('SimpleNode') or failed "Failed to navigate to SimpleNode";
    $navi->NavigateName('Enum') or failed "Failed to navigate to Enum";
    $navi->NavigateName('Item') or failed "Failed to navigate to Item";
    
};


1;
