package Test::DOM::Builder;
use strict;
use warnings;

use base qw(IMPL::Test::Unit);
__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use IMPL::Test qw(test failed shared);

require IMPL::DOM::Schema;
require IMPL::DOM::Navigator::Builder;
require IMPL::DOM::Document;

BEGIN {
    public property schemaDoc => prop_all;
}

sub CTOR {
    my ($this) = @_;
    
    my $schema = new IMPL::DOM::Schema;
    $schema->appendRange(
        IMPL::DOM::Schema::ComplexNode->new( name => 'personInfo' )->appendRange(
            IMPL::DOM::Schema::NodeSet->new()->appendRange(
                new IMPL::DOM::Schema::SimpleNode( name => 'firstName' ),
                new IMPL::DOM::Schema::SimpleNode( name => 'lastName' ),
                new IMPL::DOM::Schema::ComplexNode( name => 'address', maxOccur => 'unbounded' )->appendRange(
                    IMPL::DOM::Schema::NodeSet->new()->appendRange(
                        new IMPL::DOM::Schema::SimpleNode( name => 'street' ),
                        new IMPL::DOM::Schema::SimpleNode( name => 'line', minOccur => 0 )
                    )
                )
            )
        )
    );
    
    $this->schemaDoc( $schema );
}

test CreateBuilder => sub {
    my ($this) = @_;
    
    my $builder = IMPL::DOM::Navigator::Builder->new(
        new IMPL::DOM::Document(nodeName => 'personInfo'),
        $this->schemaDoc
    );
};

test BuildDocument => sub {
    my ($this) = @_;
    
    my $builder = IMPL::DOM::Navigator::Builder->new(
        'IMPL::DOM::Document',
        $this->schemaDoc
    );
    
    use Time::HiRes qw(gettimeofday tv_interval);
    
    my $t = [gettimeofday];
    
    $builder->NavigateCreate('personInfo', version => '1');
        $builder->NavigateCreate('firstName')->nodeValue('Nemo');
        $builder->Back();
        $builder->NavigateCreate('lastName')->nodeValue('Nobel');
        $builder->Back();
        $builder->NavigateCreate('lastName')->nodeValue('Gardum');
        $builder->Back();
        for(1..100) {
            $builder->NavigateCreate('address', local => 1);
                $builder->NavigateCreate('street')->nodeValue('Hellroad');
                $builder->Back();
                $builder->NavigateCreate('line')->nodeValue($_);
                $builder->Back();
            $builder->Back();
        }
    $builder->Back();
    
    print "Build: ",tv_interval($t,[gettimeofday]),"\n";
    $t = [gettimeofday];
    print $_->Message,"\n" foreach $this->schemaDoc->Validate($builder->Document);
    print "Validate: ",tv_interval($t,[gettimeofday]),"\n";
    
    return 1;
};


1;
