package IMPL::Web::Handler::JSONView;
use strict;
use JSON;

use IMPL::lang qw(is);
use IMPL::declare {
    require => {
        HttpResponse => 'IMPL::Web::HttpResponse',
        ViewResult => '-IMPL::Web::ViewResult'        
    },
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Serializable' => undef,
		'IMPL::Object::Autofill' => '@_'
	]
};

sub contentType {
	'application/json'
}

sub Invoke {
	my ($this,$action,$next) = @_;
	
	my $result = $next ? $next->($action) : undef;
	
	
	my $model = ( ref $result and is($result,ViewResult) )
	   ? $result->model
	   : $result;
	
	$model = [$model] unless ref $model;
	
	my %params = (
        type => $this->contentType,
        charset => 'utf-8',             
        body => JSON->new->utf8->pretty->encode($model)
	);
	
	if(is($result,ViewResult)) {
    	$params{status} = $result->status if $result->status;
    	$params{headers} = $result->headers if $result->headers;
    	$params{cookies} = $result->cookies if $result->cookies;
	}
	
    return HttpResponse->new(
        %params
    );
}

1;

__END__

=pod

=head1

=cut