#!/usr/bin/perl
use strict;

use IMPL::require {
	TTContext => 'IMPL::Web::View::TTContext'
};

my $ctx = TTContext->new({
	INCLUDE_PATH => './Resources/view',
	INTERPOLATE => 1,
	RECURSION => 1000
});

print $ctx->invoke_environment(sub {
	my ($this) = @_;
	return $this->render(
	    'default',
	    {
	    	content => sub {
	    		return $this->invoke_environment(
	    		    sub {
		    			shift->render(
			                'product/view',
			                {
					            model => {
								    name => 'debugger',
								    manufature => {
										name => 'DEBUGGERS INC',
										address => [
										     {
										     	coutry => 'Russuia',
										     	city => 'Moscow'
										     },
										     {
										     	country => 'GB',
										     	city => 'Essex'
										     }
										]
								    }
					            }				            
						    }
						);
		    		}, {
		    			base => 'site'
		    		}
                );
		    }
	    }
    );
}, {
	base => 'layout',
	includes => [
	   'packages'
	],
	tt_ext => 'tt',
	document => {
		title => 'Test document'
	}
});
   
