package IMPL::Security::Auth;
use strict;

use Digest::MD5 qw(md5_hex);

use constant {
    AUTH_SUCCESS => 1,
    AUTH_INCOMPLETE => 2,
    AUTH_FAIL => 3    
};

use parent qw(Exporter);

our @EXPORT_OK = qw(&AUTH_SUCCESS &AUTH_INCOMPLETE &AUTH_FAIL &GenSSID);
our %EXPORT_TAGS = (Const => [qw(&AUTH_SUCCESS &AUTH_INCOMPLETE &AUTH_FAIL)]);

{
    my $i = 0;
    sub GenSSID {
        return md5_hex(time,rand,$i++);
    }
}

sub DoAuth {
    die new IMPL::NotImplementedException;
}

sub isTrusted {
    0;
}

sub Create {
    my ($self,%args) = @_;
    
    return $self->new($self->CreateSecData(%args));
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Auth> Базовыйы класс для объектов аутентификации.

=head1 DESCRIPTION

C<[Abstract]>

Объект аутентификации служет для аутентификации клиента, в случае успеха
образуется сессия идентифицирующая клиента, которая представлена на стороне
сервера объектом аутентификации.

Аутентификация носит итеративный характер, объект аутентификации сохраняет
состояние между итерациями.

Результатом аутентификации является сессия, состояние этой сессии также хранит объект
аутентификации.

В процессе авторизации клиент и сервер обмениеваются данными безопасности C<$challenge>.
И результатом каждой итерации является либо упех (C<AUTH_SUCCESS>), либо запрос на продолжение
(C<AUTH_INCOMPLETE>), либо неудача (C<AUTH_FAIL>). Количество итераций может быть разным,
зависит от пакета аутентификации.

=head1 EXPORT

=over

=item C<:Const>

Константы результата аутентификации

=over

=item C<AUTH_SUCCESS>

Успешная аутентификация

=item C<AUTH_INCOMPLETE>

Требуются дополнительные шаги

=item C<AUTH_FAIL>

Аутентификация неуспешна.

=back

=back

=head1 MEMBERS

=over

=item C<CTOR($SecData)>

Создает пакет для авторизации на основе данных безопасности для пользователя.
C<$SecData> - Зависит от пакета аутентификации.

=item C<[get] isTrusted>

Флаг того, что аутентификация закончена успешно и сессия создана. Данный объект
может быть создан для аутентификации сессии.

=item C<DoAuth($challenge)>

Производит аутентификацию пользователя, возвращает результат
аутентификации, в виде массива ($status,$challenge).

Даже после успешной аутентификации полученные данные C<$challenge> должны быть 
отправлены клиенту для завершения аутентификации на стороне клиента.

=item C<[static] CreateSecData(%args)>

Создает данные безопасности, на основе параметров. Параметры зависят от пакета
аутентификации.

=item C<[static] Create(%args)>

Создает объект аутентификации, на основе параметров. Параметры зависят от
пакета аутентификации. Внутри вызывает метод C<CreateSecData(%args)>.

=item C<[static] SecDataArgs()>

Возвращает хеш с описанием параметров для функции C<CreateSecData>.
Ключами являются имена параметров, значениями - типы.

=back 

=cut
