package IMPL::Web::Handler::JSONView;
use strict;
use JSON;

use IMPL::declare {
    require => {
        HttpResponse => 'IMPL::Web::HttpResponse',
        ViewResult => '-IMPL::Web::ViewResult'        
    },
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Serializable' => undef,
		'IMPL::Object::Autofill' => '@_'
	]
};

sub contentType {
	'application/json'
}

sub Invoke {
	my ($this,$action,$next) = @_;
	
	my $result = $next ? $next->($action) : undef;
	
	
	my $model = ( ref $result and eval { $result->isa(ViewResult) } )
	   ? $result->model
	   : $result;
	
	$model = [$model] unless ref $model;
	
    return HttpResponse->new({
        type => $this->contentType,
        charset => 'utf-8',             
        body => JSON->new->utf8->pretty->encode($model)
    });
}

1;

__END__

=pod

=head1

=cut