package IMPL::Web::Response;

use base qw(IMPL::Object);

require IMPL::Exception;

use IMPL::Class::Property;
use HTTP::Response;

BEGIN {
	public property request => prop_get; # cgi query
	public property contentType => prop_all, { validator => \&_checkHeaderPrinted }; # String
	public property buffered => prop_get; # Boolean
	public property cookies => prop_all, { validator => \&_checkHeaderPrinted }; # Hash
	public property streamBody => { get => \&getStreamBody }; # stream
	
	private property _streamBody => prop_all; # stream
	private property _streamOut => prop_all; # stream
	private property _isHeaderPrinted => prop_all; # Boolean 
}

sub _checkHeaderPrinted {
	my ($this,$value) = @_;
	
	die new IMPL::InvalidOperationException() if $this->_isHeaderPrinted;
}

sub getStreamBody {
	my ($this) = @_;
	
	return $this->_streamBody if $this->buffered;
	
	
}

sub _PrintHeader {
	my ($this) = @_;
	
	unless ($this->_isHeaderPrinted) {
		$this->_isHeaderPrinted(1);
		
		
	}
}

sub Send {
	
}

1;

__END__

=pod



=cut