package IMPL::Web::Handler::RestController;
use strict;

use IMPL::lang qw(:declare :constants);


use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgumentExecption => '-IMPL::InvalidArgumentException',
		HttpException => 'IMPL::Web::Exception',
        NotFoundException => 'IMPL::Web::NotFoundException'
	},
	base => {
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	}	
};

BEGIN {
	public property root => PROP_GET | PROP_OWNERSET;
	public property contract => PROP_GET | PROP_OWNERSET;
}

sub CTOR {
	my ($this) = @_;
	
	die ArgumentException->new("root") unless $this->root;
	die ArgumentException->new("contract") unless $this->contract;
}

sub Invoke {
	my ($this,$action) = @_;
	
	my $query = $action->query;
	
	my $method = $query->request_method;
	
	#TODO: path_info is broken for IIS
	my $pathInfo = $query->path_info;
	
	my @segments = split /\//, $pathInfo, -1; # keep trailing empty string if present
	
	# remove first segment since it's always empty
	shift @segments;
	
	my ($obj,$view) = (pop(@segments) =~ m/(.*?)(?:\.(\w+))?$/);
	push @segments, $obj;
	
	my $res = $this->contract->Transform($this->root, { id => '' } );
	
	while(@segments) {
		my $id = shift @segments;
		
		$res = $res->FetchChildResource($id,$action);
		
		die NotFoundException->new() unless $res;
	}
	
	$res = $res->InvokeHttpMethod($method,$action);
}

1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Использует C<$ENV{PATH_INFO}> для получения ресурса и вызова метода.


=cut