package IMPL::DOM::Schema::Validator::RegExp;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Label => 'IMPL::DOM::Schema::Label',
		ValidationError => 'IMPL::DOM::Schema::ValidationError'
	},
	base => [
		'IMPL::DOM::Schema::Validator' => sub {
	        my %args = @_;
	        $args{nodeName} ||= 'RegExp';
	        %args;
	    }
	],
	props => [
		message => { get => 1, set =>1, dom =>1 },
		launder => { get => 1, set =>1, dom =>1 },
		_rx => { get=> 1, set=> 1}
	]
};

sub CTOR {
    my ($this,%args) = @_;
    
    $this->message($args{message} || "A %node.nodeName% doesn't match to the format %schemaNode.label%");
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    my $rx = $this->_rx() || $this->_rx( map qr{$_}, $this->nodeValue );
    
    return ValidationError->new (
        node => $node,
        schemaNode => $ctx->{schemaNode},
        schemaType => $ctx->{schemaType},
        message => $this->_MakeLabel($this->message)
    ) unless (not $node->isComplex) and $node->nodeValue =~ /($rx)/;
    
    $node->nodeValue($1) if $this->launder;
    
    return ();
}

sub _MakeLabel {
	my ($this,$label) = @_;
	
	if ($label =~ /^ID:(\w+)$/) {
		return Label->new($this->document->stringMap, $1);
	} else {
		return $label;
	}
}

1;
