package IMPL::DOM::Schema::SimpleNode;
use strict;
use warnings;

use IMPL::declare {
	base => [
		'IMPL::DOM::Schema::Node' => sub {
			my %args = @_;
        	$args{nodeName} ||= 'SimpleNode';
            %args
		}
	]
};

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    $ctx->{schemaNode} ||= $this; # для безымянных типов
    
    $ctx->{schemaType} = $this;
    
    my @result;
    
    push @result, $_->Validate($node,$ctx) foreach $this->childNodes;
    
    return @result;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::SimpleNode> - узел с текстом.

=head1 DESCRIPTION

Узел имеющий простое значение. Данный узел может содержать ограничения
на простое значение.

Производит валидацию содержимого, при постоении DOM модели не имеет специального
типа и будет создан в виде C<IMPL::DOM::Node>.

Также определяет как будет воссоздано значение узла в DOM модели.

=cut
