package IMPL::Web::QueryHandler::UrlController;
use strict;
use base qw(IMPL::Web::QueryHandler);

use IMPL::Class::Property;
use IMPL::Exception;
use Carp qw(croak);

BEGIN {
	public property namespace => prop_all;
}

__PACKAGE__->PassThroughArgs;

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $namespace = $this->namespace || $action->application->type;
	
	my @target = grep $_, split /\//, ($ENV{PATH_INFO} || '') or die new IMPL::Exception("No target specified");
	
	my $method = pop @target;
	$method =~ s/\.\w+$//;
	
	my $module = join '::',$namespace,@target;
	
	eval "require $module; 1;" unless eval{ $module->can('InvokeAction'); };
	if (my $err = $@ ) {
		die new IMPL::Exception("Failed to load module",$module,$err);
	}
	
	if(UNIVERSAL::can($module,'InvokeAction')) {
		$module->InvokeAction($method,$action);
	} else {
		die new IMPL::InvalidOperationException("Failed to invoke action",$ENV{PATH_INFO},$module,$method);
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::QueryHandler::UrlController> -     <url> .

=head1 DESCRIPTION

  C<$ENV{PATH_INFO}>      .

=cut