package IMPL::Web::Application::Action;
use strict;

use Carp qw(carp);

use IMPL::Const qw(:prop);

use IMPL::declare {
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Autofill' => '@_'
    ],
    props => [
        application => PROP_RO,
        query => PROP_RO
    ]
};

sub CTOR {
    my ($this) = @_;
}

sub cookie {
    my ($this,$name,$rx) = @_;
    
    $this->_launder(scalar( $this->query->cookie($name) ), $rx );
}

sub param {
    my ($this,$name,$rx) = @_;
    
    $this->_launder(scalar( $this->query->param($name) ), $rx );
}

sub requestMethod {
    my ($this) = @_;
    return $this->query->request_method;
}

sub pathInfo {
    my ($this) = @_;
    return $this->query->path_info;
}

sub baseUrl {
    my ($this) = @_;
    
    return $this->query->url(-base => 1);
}

sub _launder {
    my ($this,$value,$rx) = @_;
    
    if ( $value ) {
        if ($rx) {
            if ( my @result = ($value =~ m/$rx/) ) {
                return @result > 1 ? \@result : $result[0];
            } else {
                return;
            }
        } else {
            return $value;
        }
    } else {
        return;
    }
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::Action> - Обертка вокруг C<CGI> запроса.

=head1 DESCRIPTION

C<[Infrastructure]>
Свзяывет CGI запрос, приложение, орабатывающее его и ответ, который будет отправлен клиенту.

=head1 MEMBERS

=head2 C<CTOR(%args)>

Инициализирует новый экземпляр. Именованными параметрами передаются значения
свойств.

=head2 C< [get]application>

Экземпляр приложения создавшего текущий объект

=item C< [get] query >

Экземпляр C<CGI> запроса

=back


=cut
