package IMPL::Web::Application::Action;
use strict;

use parent qw(IMPL::Object IMPL::Object::Autofill);

__PACKAGE__->PassThroughArgs;

use IMPL::Class::Property;
use Carp qw(carp);

BEGIN {
    public property application => prop_get | owner_set;
    public property query => prop_get | owner_set;
    private property _entryPoint => prop_all;
}

sub CTOR {
    my ($this) = @_;
}

sub Invoke {
    my ($this) = @_;
    
    if ($this->_entryPoint) {
        $this->_entryPoint->();
    } else {
        die new IMPL::InvalidOperationException("At least one handler is required");
    }
}

sub cookie {
    my ($this,$name,$rx) = @_;
    
    $this->_launder(scalar( $this->query->cookie($name) ), $rx );
}

sub param {
    my ($this,$name,$rx) = @_;
    
    $this->_launder(scalar( $this->query->param($name) ), $rx );
}

sub requestMethod {
    my ($this) = @_;
    return $this->query->request_method;
}

sub pathInfo {
    my ($this) = @_;
    return $this->query->path_info;
}

sub _launder {
    my ($this,$value,$rx) = @_;
    
    if ( $value ) {
        if ($rx) {
            if ( my @result = ($value =~ m/$rx/) ) {
                return @result > 1 ? \@result : $result[0];
            } else {
                return;
            }
        } else {
            return $value;
        }
    } else {
        return;
    }
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::Action> - Обертка вокруг C<CGI> запроса.

=head1 DESCRIPTION

C<[Infrastructure]>
Свзяывет CGI запрос, приложение, орабатывающее его и ответ, который будет отправлен клиенту.

=head1 MEMBERS

=head2 C<CTOR(%args)>

Инициализирует новый экземпляр. Именованными параметрами передаются значения
свойств.

=head2 C< [get]application>

Экземпляр приложения создавшего текущий объект

=item C< [get] query >

Экземпляр C<CGI> запроса

=back


=cut
