package IMPL::Class::PropertyInfo;
use strict;

use parent qw(IMPL::Class::MemberInfo);

our %CTOR = ( 'IMPL::Class::MemberInfo' => '@_' );

__PACKAGE__->mk_accessors(qw(Type Mutators canGet canSet ownerSet));

my %LoadedModules;

sub CTOR {
    my $this = shift;
    
    if ( my $type = $this->Attributes ? delete $this->Attributes->{type} : undef ) {
        $this->Type($type);
    }
    
    $this->Mutators(0) unless defined $this->Mutators;
}

sub Implementor {
    my $this = shift;
        
    if (@_) {
        $this->SUPER::Implementor(@_);
    } else {
        my $implementor = $this->SUPER::Implementor;
        return $implementor if $implementor;
        
        $implementor = $this->SelectImplementor();
        
        $this->Implementor($implementor);
    }
    
}

sub SelectImplementor {
    eval {$_[0]->Class->_PropertyImplementor} or die new IMPL::Exception('Can\'t find a property implementor for the specified class',$_[0]->Class);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Class::PropertyInfo> - метаданные о свойствах объектов. Используются для отражения и
проверки данных объектов.

=head1 DESCRIPTION

В зависимости от типа каждый объект предоставляет способ хранения данных, например хеши позволяют
хранить состояние в виде ассоциативного массива и т.д. Информация о свойстве предоставляет определенный
уровень абстракции. 

=cut
